uniform sampler2D texTo;
uniform sampler2D texFrom;

uniform float progress;
uniform float levelFrom;
uniform float levelTo;
uniform float xfp;

void main()
{
	vec2 uv = gl_TexCoord[0].st;
	float frequency = 20.0;
	float speed = 10.0;
	float amplitude = 0.05;
	vec2 center = vec2(0.5,0.5);
	vec2 toUV = uv - center;
	float distanceFromCenter = length(toUV);
	vec2 normToUV = toUV / distanceFromCenter;
	
	float wave = cos(frequency * distanceFromCenter - speed * progress);
	float offset1 = progress * wave * amplitude;
	float offset2 = (1.0 - progress) * wave * amplitude;
    
	vec2 newUV1 = center + normToUV * (distanceFromCenter + offset1);
	vec2 newUV2 = center + normToUV * (distanceFromCenter + offset2);

	vec4 color1 = texture2D(texFrom, newUV1);
    color1.a = levelFrom;
	vec4 color2 = texture2D(texTo, newUV2);
    color2.a = levelTo;

	gl_FragColor = mix(color1, color2, xfp);
}